#ifndef VECTOR_HPP
#define VECTOR_HPP
#include "types.h" //for Real

//====TWO DIMENSIONAL OBJECTS==== We may add more dimensions later.
//----TWO DIMENSIONAL VECTORS---- We may add matrices later.

class Vector2
{
private:
	Real _x, _y;
public:
	//--------Constructors------------------------------
	Vector2(){_x = _y = 0.0;}
	Vector2(Real ix, Real iy){_x = ix; _y = iy;}
	//--------Accessors------------------------------
	Real x()const {return _x;}
	Real y()const {return _y;}
	Real Magnitude()const; //Return the Vector2's length.
	//--------Mutators------------------------------
	void Set(Real ix, Real iy){_x = ix; _y = iy;}
	Vector2 Normalize(); //Make yourself of unit length, return self.
	Real MagnitudeNormalize(); /* This not an obvious method, but it
		is handy: make yourself of unit length, return magnitude. */
	Vector2 Rotate(Real angle); //Rotate angle radians
	//--------Operators------------------------------
	Vector2 operator=(const Vector2 &u){_x=u._x; _y=u._y; return *this;}
	Vector2 operator+=(const Vector2 &u)
		{_x+=u._x; _y+=u._y; return *this;}
	Vector2 operator-=(const Vector2 &u)
		{_x-=u._x; _y-=u._y; return *this;}
	Vector2 operator*=(Real f){_x*=f; _y*=f; return *this;}
	Vector2 operator/=(Real f);
	BOOL operator()(void){return !(*this == Vector2(0.0, 0.0));}
		// This is so "if (vect()) ..." means "if (vect != Vector2(0,0)) ..."
	//--------Friend Operators-------------------------
	/* The following binary operators are friends rather than member
functions because it's not as logical to think of them as being
called by the first argument (and this wouldn;t work in any case for
scalar multipication.) */ 
	friend Vector2 operator*(const Vector2 &u, Real f); //Scalar prod
	friend Vector2 operator*(Real f, const Vector2 &u); //Scalar prod
	friend Vector2 operator+(const Vector2 &u, const Vector2 &v);
		//Vector2 sum
	friend Vector2 operator-(const Vector2 &u, const Vector2 &v);
		//Vector2 difference
	friend Real operator%(const Vector2 &u, const Vector2 &v);
		//Dot product.
/* We use the "mod" symbol % for dot product, which makes sense
because the component of u in direction v is u%(v.Normalize()).
We don't define the vector product yet because that requires 3D. */
	friend BOOL operator==(const Vector2 &u, const Vector2 &v);
		//Equality operator
};
#endif //VECTOR_HPP
